import { FormattedMessage } from "react-intl";
import { H1 } from "theme/components/atoms/Typography/Heading";
import { type FaqQueryQuery } from "~/graphql/graphql";
import FaqList from "../FaqList";

interface FaqLayoutProps {
  faq: FaqQueryQuery["faq"];
  children?: React.ReactNode;
}

const FaqLayout = (props: FaqLayoutProps) => {
  return (
    <div className="container">
      <H1>
        <FormattedMessage
          id="pages.Faq.title"
          defaultMessage="Frequently Asked Questions"
        />
      </H1>
      {props.faq && <FaqList faq={props.faq} />}
      {props.children}
    </div>
  );
};

export default FaqLayout;
