import { Outlet, useNavigate, useParams } from "@remix-run/react";
import { Fragment } from "react";
import { FormattedMessage } from "react-intl";
import Box from "theme/components/atoms/Layout/Box";
import Link from "theme/components/atoms/Typography/Link";
import type { FaqQueryQuery } from "~/graphql/graphql";
import ExpandableCard from "theme/components/molecules/Card/ExpandableCard";

interface FaqListProps {
  faq: FaqQueryQuery["faq"];
}

const FaqListItem = (props: {
  entry: NonNullable<NonNullable<FaqListProps["faq"]>[number]>;
  isActive: boolean;
}) => {
  const navigate = useNavigate();
  const href = props.isActive ? "/faq" : `/faq/${props.entry.slug}`;

  return (
    <ExpandableCard
      expanded={props.isActive}
      preview={() => <Link to={href}>{props.entry.question}</Link>}
      onToggle={() => navigate(href)}
    >
      {() => <Outlet />}
    </ExpandableCard>
  );
};

const FaqList = (props: FaqListProps) => {
  const params = useParams();

  if (props.faq?.length === 0) {
    return (
      <Box>
        <FormattedMessage
          id="modules.Faq.FaqList"
          defaultMessage="Sorry, but we don't have any question here yet."
        />
      </Box>
    );
  }

  return (
    <Fragment>
      {props.faq?.filter(Boolean).map((entry, index) => {
        if (!entry) return null;

        const isActive = Boolean(params.slug && params.slug === entry.slug);

        return (
          <FaqListItem
            key={`${entry.slug}-${index}`}
            isActive={isActive}
            entry={entry}
          />
        );
      })}
    </Fragment>
  );
};

export default FaqList;
