import type { Meta, StoryObj } from "@storybook/react-vite";
import FaqVote from "./FaqVote";
import { createRemixStub } from "@remix-run/testing";
import { json } from "@front-commerce/remix/node";

const createStub = (Story: any, success?: Boolean) => {
  return createRemixStub([
    {
      path: "/",
      Component: () => <Story />,
      action: () => {
        if (success === undefined) {
          return new Promise(() => {});
        }
        return json({ success: success });
      },
    },
  ]);
};

const meta = {
  title: "FaqDemo/FaqVote",
  component: FaqVote,
  parameters: {
    layout: "centered",
  },
  args: {},
} satisfies Meta<typeof FaqVote>;

export default meta;
type Story = StoryObj<typeof meta>;

export const Success: Story = {
  decorators: [
    (Story) => {
      const RemixStub = createStub(Story, true);
      return <RemixStub />;
    },
  ],
};

export const Error: Story = {
  decorators: [
    (Story) => {
      const RemixStub = createStub(Story, false);
      return <RemixStub />;
    },
  ],
};

export const Loading: Story = {
  decorators: [
    (Story) => {
      const RemixStub = createStub(Story);
      return <RemixStub />;
    },
  ],
};
