import { useFetcher } from "@front-commerce/remix/react";
import { Fragment } from "react";
import { FormattedMessage, defineMessages, useIntl } from "react-intl";
import Button from "theme/components/atoms/Button";
import Body, {
  BodyParagraph,
  BodyStrong,
} from "theme/components/atoms/Typography/Body";
import type { action } from "../../../../routes/_main.faq.$slug";

const messages = defineMessages({
  useful: {
    id: "modules.Faq.FaqVote.useful",
    defaultMessage: "Oui",
  },
  useless: {
    id: "modules.Faq.FaqVote.useless",
    defaultMessage: "No",
  },
});

const Vote = () => {
  const intl = useIntl();
  const fetcher = useFetcher<typeof action>();

  if (fetcher.state !== "idle") {
    return (
      <Body>
        <FormattedMessage
          id="modules.Faq.FaqVote.loading"
          defaultMessage="Sending..."
        />
      </Body>
    );
  }

  if (fetcher.data) {
    if (fetcher.data?.success) {
      return (
        <Body>
          <FormattedMessage
            id="modules.Faq.FaqVote.success"
            defaultMessage="Your feedback was sent successfully."
          />
        </Body>
      );
    } else {
      return (
        <Body>
          <FormattedMessage
            id="modules.Faq.FaqVote.error"
            defaultMessage="An error occurred when sending your feedback."
          />
        </Body>
      );
    }
  }

  const voteFormData = (isFaqUseful: boolean) => {
    const formData = new FormData();
    formData.append("isFaqUseful", isFaqUseful.toString());
    return formData;
  };

  return (
    <Fragment>
      <Button
        icon
        title={intl.formatMessage(messages.useful)}
        onClick={async () => {
          const formData = voteFormData(true);
          await fetcher.submit(formData, { method: "POST", navigate: false });
        }}
      >
        👍
      </Button>
      <Button
        icon
        title={intl.formatMessage(messages.useless)}
        onClick={async () => {
          const formData = voteFormData(false);
          await fetcher.submit(formData, { method: "POST", navigate: false });
        }}
      >
        👎
      </Button>
    </Fragment>
  );
};

const FaqVote = () => {
  return (
    <BodyParagraph>
      <BodyStrong>
        <FormattedMessage
          id="modules.Faq.FaqVote.isUseful"
          defaultMessage="Was this useful?"
        />
      </BodyStrong>{" "}
      <Vote />
    </BodyParagraph>
  );
};

export default FaqVote;
