# File Upload Demo

This is a demo extension that showcases how to implement file upload functionality in a web application. It provides a simple interface for users to select and upload files, and demonstrates how to handle file uploads on the back using Remix.

## How to use

Add the extension to you `front-commerce.config.ts`

```diff
import { defineConfig } from "@front-commerce/core/config";
import themeChocolatine from "@front-commerce/theme-chocolatine";
import storesConfig from "./app/config/stores";
import cacheConfig from "./app/config/caching";
import rateLimiterConfig from "./app/config/rateLimiter";
import appCSPProvider from "./app/config/cspProvider";
import serverEventsConfig from "./app/config/serverEvents";
import pwaConfig from "./app/config/pwa";
import maintenanceConfig from "./app/config/maintenance";
import contributionMode from "./app/config/contributionMode";
+import fileUploadDemo from "./example-extensions/file-upload-demo";

export default defineConfig({
+extensions: [themeChocolatine(), fileUploadDemo()],
stores: storesConfig,
cache: cacheConfig,
rateLimiter: rateLimiterConfig,
serverEvents: serverEventsConfig,
maintenance: maintenanceConfig,
contributionMode: contributionMode,
configuration: {
providers: [appCSPProvider()],
},
v2_compat: {
useApolloClientQueries: true,
useFormsy: true,
},
pwa: pwaConfig,
});

```

Start your skeleton and go to [http://localhost:4000/upload-demo](http://localhost:4000/upload-demo)
