import { json } from "@front-commerce/remix/node";
import { type ActionFunctionArgs } from "@remix-run/node";
import { Form, useActionData } from "@remix-run/react";
import Button from "theme/components/atoms/Button";

export default function FormUploadDemoPage() {
  const actionData = useActionData<typeof action>();
  return (
    <div className="container">
      <h1>File Upload Demo</h1>
      <Form method="post" encType="multipart/form-data">
        <input type="file" name="file" accept="text/plain,text/markdown" />
        <Button type="submit" appearance="primary">
          Upload
        </Button>
      </Form>
      {actionData?.fileContent && (
        <div>
          <h2>File content</h2>
          <pre>{actionData.fileContent}</pre>
        </div>
      )}
    </div>
  );
}

export async function action({ request }: ActionFunctionArgs) {
  const formData = await request.formData();
  const file = formData.get("file") as File;
  const fileContent = await file.text();
  return json({ fileContent });
}
