import { defineRemixExtension } from "@front-commerce/remix";
import LocalPassportProvider from "./localProvider";

const fakeUsersDB = [
  {
    firstname: "Veronica",
    lastname: "Costello",
    email: "roni_cost@example.com",
    password: "roni_cost3@example.com",
  },
  {
    firstname: "Odile",
    lastname: "Deray",
    email: "odile@mail.fr",
    password: "O.D.I.L",
  },
  {
    firstname: "Serge",
    lastname: "Karamazov",
    email: "skaramazov@protection.fr",
    password: "youri",
  },
];

export default function localPassport() {
  return defineRemixExtension({
    meta: import.meta,
    name: "local-passport",
    theme: "example-extensions/local-passport/theme",
    routes: import.meta.url,
    unstable_lifecycleHooks: {
      onServerServicesInit: (services, request, config) => {
        services.ExternalLogin.registerProvider(
          new LocalPassportProvider(fakeUsersDB),
        );
      },
    },
  });
}
