import type {
  Profile,
  ExternalLoginProvider,
} from "@front-commerce/core/external-login";
import type { ExpressCompatibleRequest } from "@front-commerce/remix/server/express/convertStandardRequestToExpressRequest";
import convertStandardRequestToExpressRequest from "@front-commerce/remix/server/express/convertStandardRequestToExpressRequest";
import passport from "passport";
import LocalStrategy from "passport-local";

interface UsersDb {
  firstname: string;
  lastname: string;
  email: string;
  password: string;
}

class LocalPassportProvider implements ExternalLoginProvider {
  name = "local-passport";
  usersDb: UsersDb[];

  constructor(usersDb: UsersDb[]) {
    this.usersDb = usersDb;
  }

  private retrieveUser(
    username: string,
    password: string,
    done: (err: any, user: any) => void,
  ) {
    const user = this.usersDb.find(
      (user) => user.email === username && user.password === password,
    );
    if (user) {
      done(null, { ...user, password: undefined });
    } else {
      done("not found", undefined);
    }
  }

  private handlePassport(request: ExpressCompatibleRequest): Promise<Profile> {
    return new Promise((resolve, reject) => {
      passport.use(new LocalStrategy(this.retrieveUser.bind(this)));
      passport.authenticate(
        "local",
        (error: string, user: Profile, info: string, status: number) => {
          if (error) {
            reject(error);
          } else {
            resolve(user);
          }
        },
      )(request);
    });
  }

  loginRoute() {
    return "/passport-local/login";
  }

  async parseProfileFromProviderCallback(
    request: Request,
  ): Promise<Profile | undefined> {
    try {
      const userInfos = await this.handlePassport(
        await convertStandardRequestToExpressRequest(request, true),
      );
      return userInfos ?? undefined;
    } catch (e) {
      return undefined;
    }
  }
}

export default LocalPassportProvider;
