import { FrontCommerceApp } from "@front-commerce/remix";
import { json } from "@front-commerce/remix/node";
import { type LoaderFunctionArgs } from "@remix-run/node";
import { CmsBlockQueryDocument } from "~/graphql/graphql";

export const loader = async ({ context, params }: LoaderFunctionArgs) => {
  const app = new FrontCommerceApp(context.frontCommerce);
  const { cmsBlockList } = await app.graphql.query(CmsBlockQueryDocument, {
    identifiers: [params.identifier],
  });

  if (!cmsBlockList || cmsBlockList?.length === 0) {
    throw new Response("not found", { status: 404 });
  }

  return json({ cmsBlock: cmsBlockList[0] });
};
