import OriginalPaymentMethodLabel from "@front-commerce/theme/modules/Checkout/Payment/PaymentMethodLabel";
import HiPayMethodLabels from "theme/hipay/HiPayMethodLabels";

interface PaymentMethodLabelProps {
  code: string;
  fallbackLabel?: string;
}

const PaymentMethodLabel = (props: PaymentMethodLabelProps) => {
  if (props.code in HiPayMethodLabels) {
    return HiPayMethodLabels[props.code as keyof typeof HiPayMethodLabels];
  }

  return <OriginalPaymentMethodLabel {...props} />;
};

export default PaymentMethodLabel;
