import { useApiFetcher } from "@front-commerce/remix/react";
import { FormattedMessage } from "react-intl";
import type { loader } from "routes/api.cms-block.$identifier";
import CmsBlock from "theme/modules/CmsBlock/CmsBlock";
import "theme/modules/User/LoginHint/LoginHint.scss";

const LoginHint = () => {
  const { data, loading } = useApiFetcher<typeof loader>(
    "/api/cms-block/login-data",
  );

  if (!loading && data) {
    return (
      <div className="login-hint">
        <CmsBlock cmsBlock={data.cmsBlock} />
      </div>
    );
  }

  return (
    <div className="login-hint">
      <p>
        <strong>
          <FormattedMessage
            id="molecules.User.LoginForm.LoginHint.label"
            defaultMessage="Demo account:"
          />
        </strong>
      </p>
      <ul className="login-hint__credentials">
        <li>
          <FormattedMessage
            id="molecules.User.LoginForm.LoginHint.email"
            defaultMessage="Email:"
          />
          &nbsp;
          <span className="login-hint__selectable-value">
            roni_cost@example.com
          </span>
        </li>
        <li>
          <FormattedMessage
            id="molecules.User.LoginForm.LoginHint.password"
            defaultMessage="Password:"
          />
          &nbsp;
          <span className="login-hint__selectable-value">
            roni_cost3@example.com
          </span>
        </li>
      </ul>
    </div>
  );
};

export default LoginHint;
