import { defineRemixExtension } from "@front-commerce/remix";
import { MetricsUrlConverter } from "@front-commerce/core/services";

export default function magento2Demo() {
  const basePath = "example-extensions/magento2-demo";
  return defineRemixExtension({
    meta: import.meta,
    name: "magento2-demo",
    theme: `${basePath}/theme`,
    configuration: {
      providers: [],
    },
    routes: import.meta.url,
    translations: `${basePath}/lang`,
    unstable_lifecycleHooks: {
      onServerInit: async (services) => {
        services.MetricsService.registerMetricsUrlConverter(
          new MetricsUrlConverter(
            /.*services\.eu1\.front-commerce\.dev.*/,
            (metricsRequest) => {
              const magentoVersion = metricsRequest.host.split(".")[0];
              const isStaging = metricsRequest.host.includes("dev");
              return `${magentoVersion} ${isStaging ? "Dev" : "Demo"}`;
            },
          ),
        );
      },
    },
  });
}
