import { useState } from "react";
import { useSearchParams } from "@remix-run/react";
import { FormattedMessage } from "react-intl";
import { H1 } from "theme/components/atoms/Typography/Heading";
import LoginForm from "theme/modules/User/LoginForm";
import ExplainedCallToAction from "theme/components/organisms/ExplainedCallToAction";
import { SuccessAlert } from "theme/components/molecules/Alert";
import Stack from "theme/components/atoms/Layout/Stack";
import RedirectToRegister from "theme/modules/User/LoginForm/RedirectToRegister";
import RegisterLink from "theme/modules/User/RegisterLink";
import LoginHint from "theme/modules/User/LoginHint";
import { useTrackPage } from "@front-commerce/remix/react";

import "theme/pages/Login/Login.scss";

const Login = (props) => {
  const [searchParams] = useSearchParams();
  const [currentData, setCurrentData] = useState({
    email: searchParams.get("email") || "",
  });
  useTrackPage("Login");

  return (
    <div className="page-content page-content--simple">
      <div className="container">
        <ExplainedCallToAction
          title={
            <H1>
              <FormattedMessage
                id="pages.Login.title"
                defaultMessage="Sign in"
              />
            </H1>
          }
        >
          <Stack desktopSize="2" mobileSize="4">
            {props.location?.state?.from === "successfulPasswordReset" ? (
              <SuccessAlert>
                <FormattedMessage
                  id="pages.Login.resetSuccess"
                  defaultMessage="Your password was reset successfully"
                />
              </SuccessAlert>
            ) : null}
            <LoginForm
              key="login"
              onLoginSuccess={() => {
                // TODO FC-1675 Redirect from the route's action*
                // The default value is here to make sure modal won't
                // redirect to /undefined as they won't use the loader
                window.location.href = props.redirectTo || "/";
              }}
              onChange={(data) => setCurrentData(data)}
              value={{ email: currentData.email }}
              additionalActions={
                <RedirectToRegister
                  renderLink={({ children }) => {
                    return <RegisterLink email={currentData.email} />;
                  }}
                />
              }
            />
            <LoginHint />
          </Stack>
        </ExplainedCallToAction>
      </div>
    </div>
  );
};

export default Login;
