import { defineRemixExtension } from "@front-commerce/remix";
import { isServiceAvailable } from "./mockApi";
import path from "path";

export default function maintenanceModeDemo() {
  const basePath = "example-extensions/maintenance-mode-demo";

  return defineRemixExtension({
    meta: import.meta,
    name: "maintenance-mode-demo",
    routes: import.meta.url,
    theme: path.join(basePath, "theme"),
    unstable_lifecycleHooks: {
      onServerInit: (services) => {
        services.MaintenanceMode.addHealthCheckService("acme", () => {
          return isServiceAvailable("acme");
        });
        services.MaintenanceMode.addHealthCheckService("contentful", () => {
          return isServiceAvailable("contentful");
        });
        services.MaintenanceMode.addHealthCheckService("custom-cms", () => {
          return isServiceAvailable("custom-cms");
        });
      },
    },
  });
}
