// This is a fake api to simulate a service health check, In a real
// application this will be done via an http request to the service
// for example `await fetch("https://api.example.com/health")`

const DEFAULT_STATE = {
  acme: true,
  contentful: true,
  "custom-cms": true,
};
let servicesStatus = { ...DEFAULT_STATE };
export type Services = typeof servicesStatus;

export const isServiceAvailable = async (service: keyof Services) => {
  // simulate a delay that would happen in a real service health check
  await new Promise((resolve) => setTimeout(resolve, Math.random() * 1000));

  return servicesStatus[service];
};

export const mockApi = {
  readServices: async () => servicesStatus,
  setServiceHealth: async (service: keyof Services, status: boolean) => {
    servicesStatus[service] = status;
  },
  resetServices: async () => {
    servicesStatus = DEFAULT_STATE;
  },
};
