import Button from "theme/components/atoms/Button";
import OriginalMaintenancePage from "@front-commerce/theme/pages/Error/Maintenance/Maintenance";
import { useState } from "react";

export default function MaintenancePage() {
  const [loading, setLoading] = useState(false);
  return (
    <div className="container">
      <OriginalMaintenancePage />
      <Button
        id="reset-maintenance"
        state={loading ? "pending" : "default"}
        onClick={async () => {
          setLoading(true);
          await fetch("/__front-commerce/demo-services", {
            method: "DELETE",
          });
          setTimeout(() => {
            window.location.reload();
          }, 5000 + 1000); // We memoize the maintenance status for 5 seconds, so we need to wait for that
        }}
      >
        Reset Maintenance
      </Button>
    </div>
  );
}
