# MDX

This extensions will show how to use MDX in Front-Commerce.

## Setup

### Install MDX bundler for vite

```sh
pnpm add @mdx-js/rollup @mdx-js/react
```

### Update `vite.config.ts`

**Please note that `mdx` plugin must be declared before `frontCommerce`**

```diff
import { defineConfig } from "vite";
import { vitePlugin as frontCommerce } from "@front-commerce/remix/vite";
+import mdx from "@mdx-js/rollup";

export default defineConfig((env) => {
  return {
    plugins: [
+     mdx({ providerImportSource: "@mdx-js/react" }),
      frontCommerce({ env })
    ],
  };
});
```

## Demo

You can load this demo extension to check if your setup is working by adding these lines to your `front-commerce.config.ts` file:

```diff
import { defineConfig } from "@front-commerce/core/config";
import themeChocolatine from "@front-commerce/theme-chocolatine";
import storesConfig from "./app/config/stores";
import cacheConfig from "./app/config/caching";
import rateLimiterConfig from "./app/config/rateLimiter";
import appCSPProvider from "./app/config/cspProvider";
import serverEventsConfig from "./app/config/serverEvents";
import pwaConfig from "./app/config/pwa";
+import mdxBlog from "./example-extensions/mdx-blog";

export default defineConfig({
  extensions: [
    themeChocolatine(),
+   mdxBlog()
  ],
  stores: storesConfig,
  cache: cacheConfig,
  rateLimiter: rateLimiterConfig,
  serverEvents: serverEventsConfig,
  configuration: {
    providers: [appCSPProvider()],
  },
  v2_compat: {
    useApolloClientQueries: true,
    useFormsy: true,
  },
  pwa: pwaConfig,
});

```

Then run your Front-Commerce app and go to [http://localhost:4000/blog](http://localhost:4000/blog)
