import { MDXProvider } from "@mdx-js/react";
import { Link, Outlet } from "@remix-run/react";

export default function BlogLayout() {
  return (
    <div className="container">
      <h1>Blog</h1>
      <MDXProvider
        components={{
          a: (props) => <Link to={String(props.href)}>{props.children}</Link>,
        }}
      >
        <Outlet />
      </MDXProvider>
    </div>
  );
}
