import { createGraphQLModule } from "@front-commerce/core/graphql";

export default createGraphQLModule({
  namespace: "Acme/PdfInvoice",
  dependencies: ["Front-Commerce/Order", "Front-Commerce/Invoice"],
  typeDefs: /* GraphQL */ `
    type AcmeInvoice implements FcInvoice {
      id: ID
    }

    type AcmeInvoice implements FcDownloadableInvoice {
      id: ID
      download: DownloadLink
    }
  `,
  loadRuntime: () => import("./runtime"),
});
