import { createGraphQLRuntime } from "@front-commerce/core/graphql";
import loaders from "./loaders";

export default createGraphQLRuntime({
  contextEnhancer: () => {
    return {
      AcmeLoaders: loaders,
    };
  },
  resolvers: {
    Order: {
      invoices: (_, __, { loaders }) => {
        return loaders.AcmeLoaders.loadInvoices();
      },
    },
    FcInvoice: {
      __resolveType: () => {
        return "AcmeInvoice";
      },
    },
    AcmeInvoice: {
      id: (_, { entity_id }, { loaders }) => {
        return loaders.AcmeLoaders.loadInvoiceId(entity_id);
      },
      download: (_, { entity_id }, { loaders }) => {
        return loaders.AcmeLoaders.loadInvoiceDownload(entity_id);
      },
    },
  },
});
