import { FrontCommerceApp } from "@front-commerce/remix";
import { type LoaderFunctionArgs } from "@remix-run/node";

export async function loader({ params, context }: LoaderFunctionArgs) {
  const app = new FrontCommerceApp(context.frontCommerce);
  const magentoEndpoint = app.config.magento.endpoint;
  const invoiceId = params.id;
  const invoiceUrl = `${magentoEndpoint}/invoices/${invoiceId}`;
  try {
    const invoice = await fetch(invoiceUrl);
    if (invoice.status !== 200) {
      return new Response("Not found", { status: 404 });
    }
    const invoiceFile = await invoice.arrayBuffer();
    return new Response(invoiceFile);
  } catch (error) {
    return new Response("Internal server error", { status: 500 });
  }
}
