import { defineExtension } from "@front-commerce/core";
import type { PublicConfig } from "@front-commerce/core/react";

type PriceDisplayDemoConfig = PublicConfig["theme"]["priceDisplay"];

const createPublicConfig = (config: PriceDisplayDemoConfig) => {
  return {
    name: "price-variant-demo:public",
    values: {
      public: {
        theme: {
          priceDisplay: {
            variants: config.variants,
            appearance: config.appearance,
          },
        },
      },
    },
  };
};

export default function priceVariantDemo(
  config: PriceDisplayDemoConfig = {
    variants: ["priceInclTax", "priceExclTax"],
    appearance: "labeled",
  },
) {
  return defineExtension({
    name: "price-variant-demo",
    meta: import.meta,
    configuration: {
      providers: [createPublicConfig(config)],
    },
  });
}
