import type { ComputedConfig } from "@front-commerce/core/config";
import memoize from "memoize";

const embedScripts = [
  "*.spotify.com",
  "*.twitter.com",
  "*.instagram.com",
  "*.facebook.net",
  "*.facebook.com",
  "*.flickr.com",
  "*.staticflickr.com",
  "*.iamcal.com",
  "*.youtube.com",
  "www.youtube-nocookie.com",
];

export default {
  name: "prismic-demo",
  slowValuesOnEachRequest: memoize(
    (req: Request, config: ComputedConfig) => {
      const cspConfig = config.contentSecurityPolicy;

      return {
        contentSecurityPolicy: {
          ...cspConfig,
          directives: {
            ...cspConfig.directives,
            scriptSrc: [
              ...cspConfig.directives.scriptSrc,
              "prismic.io",
              "static.cdn.prismic.io",
              "https://html2canvas.hertzen.com/dist/html2canvas.min.js",
              "https://cdn.tailwindcss.com",
              ...embedScripts,
            ],
            frameSrc: [
              ...cspConfig.directives.frameSrc,
              "*.prismic.io",
              ...embedScripts,
            ],
            imgSrc: [...cspConfig.directives.imgSrc, ...embedScripts],
          },
        },
      };
    },
    {
      cacheKey: ([_, config]) => {
        return config.currentShopId;
      },
    },
  ),
};
