import { defineRemixExtension } from "@front-commerce/remix";
import modules from "./modules";
import configProvider from "./configProvider";
import path from "path";
import { HomePageExtractor } from "./modules/home/HomePageExtractor";
import { SliceExtractor } from "./modules/core/SliceExtractor";
import { sharedSliceComposition } from "./theme/modules/Slices";
import {
  ProductIntegrationField,
  CategoryIntegrationField,
} from "./integration-fields";

export default function prismicDemo() {
  const basePath = "example-extensions/prismic-demo";
  return defineRemixExtension({
    meta: import.meta,
    name: "prismic-demo",
    routes: import.meta.url,
    graphql: {
      modules,
    },
    configuration: {
      providers: [configProvider],
    },
    theme: path.join(basePath, "theme"),

    unstable_lifecycleHooks: {
      onServerServicesInit: async (services, request, config, user) => {
        services.ContentMetadataExtractorRegistry.register([
          HomePageExtractor,
          SliceExtractor,
        ]);
      },
      onContentCompositionInit(composition) {
        composition.registerComposition(sharedSliceComposition);
      },
      afterServerServicesInit: async (services, request, config, user) => {
        const { integrationFields } = services.DI.get("prismic");

        integrationFields.registerSitemapField(
          "Product",
          ProductIntegrationField,
        );
        integrationFields.registerSitemapField(
          "Category",
          CategoryIntegrationField,
        );
      },
    },
  });
}
