import { SitemapIntegrationField } from "@front-commerce/prismic";
import type { MagentoSitemapCategory } from "@front-commerce/magento1";
import type { Category } from "~/graphql/graphql";

export const CategoryIntegrationField = new SitemapIntegrationField<
  MagentoSitemapCategory,
  Category
>({
  sitemapFetcher: "category",
  convertSitemapEntry: (sitemapEntry, shopUrl) => {
    if (!sitemapEntry.data) {
      return null;
    }

    let imageUrl = sitemapEntry.images?.[0];
    if (imageUrl) {
      imageUrl = new URL(imageUrl, shopUrl).toString();
    }

    let description = sitemapEntry.data.meta_description;
    if (!description) {
      description = new URL(sitemapEntry.data.route, shopUrl).toString();
    }

    return {
      id: sitemapEntry.data.entity_id,
      title: sitemapEntry.data.name,
      description: description,
      image_url: imageUrl,
      last_update: new Date(sitemapEntry.data.updated_at).valueOf(),
    };
  },
  resolveEntity: (blob, context) => {
    return context.loaders.Category.load(blob.id);
  },
});
