import { SitemapIntegrationField } from "@front-commerce/prismic";
import type { MagentoSitemapProduct } from "@front-commerce/magento1";
import type { Product } from "~/graphql/graphql";

export const ProductIntegrationField = new SitemapIntegrationField<
  MagentoSitemapProduct,
  Product
>({
  sitemapFetcher: "products",
  convertSitemapEntry: (sitemapEntry, shopUrl) => {
    if (!sitemapEntry.data) {
      return null;
    }

    let imageUrl = sitemapEntry.images?.[0];
    if (imageUrl) {
      imageUrl = new URL(imageUrl, shopUrl).toString();
    }
    return {
      id: sitemapEntry.data.sku,
      title: sitemapEntry.data.name,
      description: sitemapEntry.data.short_description,
      image_url: imageUrl,
      last_update: new Date(sitemapEntry.data.updated_at).valueOf(),
    };
  },
  resolveEntity: (blob, context) => {
    return context.loaders.Product.load(blob.id);
  },
});
