import { createPrismicMetadataExtractor } from "@front-commerce/prismic";

// This is a HOF that adds a sliceID field to the resolvers
// To extract the unique identifier for the X-Ray component
export function withSliceFields<T extends Record<string, any>>(resolvers: T) {
  return {
    sliceID: (content: any) => content.documentMetadata.sliceID,
    ...resolvers,
  };
}

export const SliceExtractor = createPrismicMetadataExtractor(
  "PrismicSlice",
  (content, source) => {
    return source.documentMetadata.sliceID ?? "";
  },
);
