import { createGraphQLModule } from "@front-commerce/core/graphql";

export default createGraphQLModule({
  namespace: "Demo/Prismic/Core",
  dependencies: ["Prismic/Core", "Front-Commerce/Wysiwyg"],
  typeDefs: /* GraphQL */ `
    union SharedSlice =
      | Carousel
      | Push
      | FeaturedProductsList
      | ProductsList
      | RichText
      | CustomEmbed

    type Carousel @storefrontContent(extractorIdentifier: "PrismicSlice") {
      sliceID: String
      slides: [CarouselSlide]
    }
    type CarouselSlide {
      title: String
      image: String
      cta: CallToAction
    }
    type CallToAction {
      url: String
      text: String
    }
    type Push @storefrontContent(extractorIdentifier: "PrismicSlice") {
      sliceID: String
      blocks: [PushBlock]
    }
    type PushBlock {
      title: String
      image: String
      cta: CallToAction
      format: String
      cellSize: String
    }
    type FeaturedProductsList
      @storefrontContent(extractorIdentifier: "PrismicSlice") {
      sliceID: String
      title: String
      category: Category
    }
    type ProductsList @storefrontContent(extractorIdentifier: "PrismicSlice") {
      sliceID: String
      title: String
      products: [Product]
    }
    type RichText @storefrontContent(extractorIdentifier: "PrismicSlice") {
      sliceID: String
      content: PrismicWysiwyg
    }
    type CustomEmbed @storefrontContent(extractorIdentifier: "PrismicSlice") {
      sliceID: String
      html: String
    }
  `,
  loadRuntime: () => import("./runtime"),
});
