import type { PrismicLoader as TPrismicLoader } from "@front-commerce/prismic/graphql";
import {
  CategoryIntegrationField,
  ProductIntegrationField,
} from "../../integration-fields";

export function PrismicDemoCoreLoader(
  PrismicLoader: TPrismicLoader,
  WysiwygLoader: any,
  domains: (string | RegExp)[],
) {
  const {
    TitleTransformer,
    GroupTransformer,
    ImageTransformer,
    LinkTransformer,
    RichtextToTextTransformer,
    IntegrationFieldTransformer,
    RichtextToWysiwygTransformer,
  } = PrismicLoader.transformers;
  const Slice = PrismicLoader.Slice;

  const linkTransformer = new LinkTransformer(domains);

  const sharedSlices = [
    new Slice("products_list", {
      graphQLType: "ProductsList",
      fieldTransformers: {
        items: new GroupTransformer({
          product: new IntegrationFieldTransformer(ProductIntegrationField),
        }),
      },
    }),
    new Slice("featured_products_list", {
      graphQLType: "FeaturedProductsList",
      fieldTransformers: {
        category: new IntegrationFieldTransformer(CategoryIntegrationField),
      },
    }),
    new Slice("carousel", {
      graphQLType: "Carousel",
      fieldTransformers: {
        items: new GroupTransformer({
          slide_title: new TitleTransformer(),
          slide_image: new ImageTransformer(),
          slide_cta_url: linkTransformer,
          slide_cta_text: new RichtextToTextTransformer(),
        }),
      },
    }),
    new Slice("push", {
      graphQLType: "Push",
      fieldTransformers: {
        items: new GroupTransformer({
          push_title: new TitleTransformer(),
          push_block_image: new ImageTransformer(),
          push_url: linkTransformer,
          push_link_text: new RichtextToTextTransformer(),
        }),
      },
    }),
    new Slice("richtext", {
      graphQLType: "RichText",
      fieldTransformers: {
        content: new RichtextToWysiwygTransformer(
          WysiwygLoader,
          linkTransformer,
        ),
      },
    }),
    new Slice("custom_embed", {
      graphQLType: "CustomEmbed",
      fieldTransformers: {
        html: {
          transform: (content) => content?.[0]?.text || "",
        },
      },
    }),
  ];

  return {
    getSharedSlices: () => sharedSlices,
  };
}
