import { createGraphQLModule } from "@front-commerce/core/graphql";

export default createGraphQLModule({
  namespace: "Demo/Prismic/Home",
  dependencies: ["Prismic/Core", "Front-Commerce/Wysiwyg", "Demo/Prismic/Core"],
  typeDefs: /* GraphQL */ `
    extend type Query {
      homePage: HomePage
    }

    type HomePage @storefrontContent(extractorIdentifier: "PrismicHomePage") {
      mainContent: [SharedSlice]
      meta: HomePageMeta
    }

    type HomePageMeta {
      title: String
      description: String
      image: String
    }
  `,
  loadRuntime: () => import("./runtime"),
});
