import { createGraphQLRuntime } from "@front-commerce/core/graphql";

import {
  PrismicCachedResolver,
  type PrismicLoaders,
} from "@front-commerce/prismic/graphql";

export default createGraphQLRuntime({
  contextEnhancer: ({ config, loaders }) => {
    const PrismicLoader = (loaders as PrismicLoaders).Prismic;

    const { LinkTransformer, RichtextToWysiwygTransformer, ImageTransformer } =
      PrismicLoader.transformers;

    const linkTransformer = new LinkTransformer([
      config.shop.url,
      /.*\.front-commerce.app/,
      /.*\.platform.site/,
      /^http:\/\/localhost/,
    ]);

    const contentTransformOptions = {
      fieldTransformers: {
        meta_image: new ImageTransformer(config.shop.baseUrl),
        top_content: new RichtextToWysiwygTransformer(
          loaders.Wysiwyg,
          linkTransformer,
        ),
      },
      supportedSlices: loaders.PrismicDemoCore.getSharedSlices() || [],
    };

    PrismicLoader.defineContentTransformers(
      "home_page",
      contentTransformOptions,
    );

    return {};
  },

  resolvers: {
    Query: {
      homePage: PrismicCachedResolver((_, __, { loaders }) => {
        return loaders.Prismic.loadSingle("home_page");
      }),
    },
    HomePage: {
      mainContent: (content) => content.body,
      meta: (content, _, { config }) => ({
        title: content.meta_title,
        description: content.meta_description,
        image: new URL(
          content.meta_image.valueOf(),
          config.shop.url,
        ).toString(),
      }),
    },
  },
});
