import Home from "theme/pages/Home/PrismicHome";
import { generateMetas, json } from "@front-commerce/remix/node";
import type {
  LoaderFunctionArgs,
  MetaDescriptor,
  MetaFunction,
} from "@remix-run/node";
import { FrontCommerceApp } from "@front-commerce/remix";
import { HomePageQueryDocument } from "~/graphql/graphql";
import {
  useLoaderData,
  type UseDataFunctionReturn,
} from "@front-commerce/remix/react";

export const loader = async ({ context }: LoaderFunctionArgs) => {
  const app = new FrontCommerceApp(context.frontCommerce);

  const data = await app.graphql.query(HomePageQueryDocument);

  if (!data?.homePage) {
    throw new Response("Home page not found", { status: 404 });
  }

  app.services.CacheControl.setCacheable({
    sMaxAge: 60,
    staleWhileRevalidate: 21600,
  });

  return json(data.homePage);
};

export const meta: MetaFunction = (args: any) => {
  const data = args.data as UseDataFunctionReturn<typeof loader>;
  let metaTags = [] as MetaDescriptor[];
  if (data.meta?.title) {
    metaTags.push(
      ...[
        { title: data.meta.title },
        {
          property: "og:title",
          content: data.meta.title,
        },
      ],
    );
  }
  if (data.meta?.description) {
    metaTags.push(
      ...[
        {
          description: data.meta.description,
          property: "og:description",
          content: data.meta.description,
        },
      ],
    );
  }
  if (data.meta?.image) {
    metaTags.push(
      ...[
        {
          image: data.meta.image,
          property: "og:image",
          content: data.meta.image,
        },
      ],
    );
  }

  const metas = generateMetas(() => metaTags, "/");
  return metas(args);
};

export default function Index() {
  const data = useLoaderData<typeof loader>();

  return <Home data={data} />;
}
