import MegaHeading from "theme/components/atoms/Typography/Heading/Mega";
import Carousel from "theme/components/organisms/Carousel";
import { CAROUSEL_IMAGE_SIZES } from "theme/pages/Home/HomeConstants";
import type { Carousel as CarouselProps } from "~/graphql/graphql";

const CarouselLocal = (props: CarouselProps) => {
  const slides = props.slides?.filter(Boolean).map((slide, index) => ({
    key: index,
    title: (
      <MegaHeading as={index === 0 ? "h1" : "h2"}>{slide.title}</MegaHeading>
    ),
    to: slide.cta?.url ?? "#",
    linkTitle: slide.cta?.text ?? "",
    imageSrc: slide.image,
    priority: true,
  }));

  return <Carousel slides={slides} imageSizes={CAROUSEL_IMAGE_SIZES} />;
};

export default CarouselLocal;
