import FeaturedProducts from "theme/modules/ProductList/FeaturedProducts";
import Section from "theme/components/organisms/Section";
import { H2 } from "theme/components/atoms/Typography/Heading";
import { FEATURED_PRODUCTS_IMAGE_SIZES } from "theme/pages/Home/HomeConstants";
import type { FeaturedProductsList as FeaturedProductsListProps } from "~/graphql/graphql";

const FeaturedProductsList = (props: FeaturedProductsListProps) => {
  if (!props.category) {
    return <h1>Category not found!</h1>;
  }
  return (
    <Section title={<H2>{props.title || props.category.name || ""}</H2>}>
      <FeaturedProducts
        categoryId={props.category.id}
        imageSizes={FEATURED_PRODUCTS_IMAGE_SIZES}
        prioritizeTop={0}
      />
    </Section>
  );
};

export default FeaturedProductsList;
