import { H2 } from "theme/components/atoms/Typography/Heading";
import Section from "theme/components/organisms/Section";
import ProductListSlider from "theme/modules/ProductList/ProductListSlider";
import { FEATURED_PRODUCTS_IMAGE_SIZES } from "theme/pages/Home/HomeConstants";
import type { ProductsList as ProductsListProps } from "~/graphql/graphql";

const ProductsList = (props: ProductsListProps) => {
  if (!props.products?.length) {
    return <h1>No Products Selected!</h1>;
  }
  return (
    <Section title={<H2>{props.title || ""}</H2>}>
      <ProductListSlider
        length={props.products.length}
        numberOfProductsPerSlide={props.products.length}
        products={props.products}
        imageSizes={FEATURED_PRODUCTS_IMAGE_SIZES}
      />
    </Section>
  );
};
export default ProductsList;
