import { H2 } from "theme/components/atoms/Typography/Heading";
import Link from "theme/components/atoms/Typography/Link";
import PushBlock from "theme/components/organisms/PushBlock";
import Cell from "theme/components/templates/Grid/Cell";
import Grid from "theme/components/templates/Grid/Grid";
import type { Push as PushProps } from "~/graphql/graphql";

const Push = (props: PushProps) => {
  return (
    <Grid>
      {props.blocks?.filter(Boolean).map((block, index) => (
        <Cell size={block.cellSize} key={index}>
          <PushBlock imageSrc={block.image || ""} format={block.format || ""}>
            <H2>{block.title || ""}</H2>
            {block.cta?.text && (
              <Link buttonAppearance="default" to={block.cta.url || "#"}>
                {block.cta.text || ""}
              </Link>
            )}
          </PushBlock>
        </Cell>
      ))}
    </Grid>
  );
};
export default Push;
