import { createContentComposition } from "@front-commerce/core";

const sharedSliceComposition = createContentComposition("SharedSlice", [
  {
    name: "Carousel",
    client: {
      component: new URL("./Carousel.tsx", import.meta.url),
      fragment: /* GraphQL */ `
        fragment CarouselFragment on Carousel {
          sliceID
          slides {
            title
            image
            cta {
              url
              text
            }
          }
        }
      `,
    },
  },
  {
    name: "CustomEmbed",
    client: {
      component: new URL("./CustomEmbed.tsx", import.meta.url),
      fragment: /* GraphQL */ `
        fragment CustomEmbedFragment on CustomEmbed {
          sliceID
          html
        }
      `,
    },
  },
  {
    name: "FeaturedProductsList",
    client: {
      component: new URL("./FeaturedProductsList.tsx", import.meta.url),
      fragment: /* GraphQL */ `
        fragment FeaturedProductsListFragment on FeaturedProductsList {
          sliceID
          title
          category {
            id
            name
          }
        }
      `,
    },
  },
  {
    name: "ProductsList",
    client: {
      component: new URL("./ProductsList.tsx", import.meta.url),
      fragment: /* GraphQL */ `
        #import "theme/modules/ProductView/ProductItem/ProductItemFragment.gql"

        fragment ProductsListFragment on ProductsList {
          sliceID
          title
          products {
            ...ProductItemFragment
          }
        }
      `,
    },
  },
  {
    name: "Push",
    client: {
      component: new URL("./Push.tsx", import.meta.url),
      fragment: /* GraphQL */ `
        fragment PushFragment on Push {
          sliceID
          blocks {
            title
            image
            cta {
              url
              text
            }
            format
            cellSize
          }
        }
      `,
    },
  },
  {
    name: "RichText",
    client: {
      component: new URL("./RichText.tsx", import.meta.url),
      fragment: /* GraphQL */ `
        fragment RichTextFragment on RichText {
          sliceID
          content {
            ...WysiwygFragment
          }
        }
      `,
    },
  },
]);

export default sharedSliceComposition;
