import type { HomePage } from "~/graphql/graphql";
import StorefrontContent from "theme/modules/StorefrontContent";
import { CompositionComponent } from "@front-commerce/core/react";
import Stack from "theme/components/atoms/Layout/Stack";

import "./PrismicHome.scss";

const SmartStorefrontContent = ({
  sliceID,
  className = "",
  children,
}: React.PropsWithChildren<{ sliceID?: string; className?: string }>) => {
  if (sliceID) {
    return (
      <div className={className || ""}>
        <StorefrontContent type="PrismicSlice" id={sliceID}>
          {children}
        </StorefrontContent>
      </div>
    );
  }
  return <div className={className || ""}>{children}</div>;
};

export default function PrismicHome({ data }: { data: HomePage }) {
  return (
    <StorefrontContent type="PrismicHomePage" id="home_page" scope="page">
      <CompositionComponent
        name="SharedSlice"
        content={data.mainContent}
        renderComponents={(components) => {
          return <Stack size="8">{components}</Stack>;
        }}
        renderComponent={(slice) => {
          let className = "";
          if (slice.props.__typename === "RichText") {
            className = "container prismic-home__rich-text";
          }
          if (slice.props.__typename === "CustomEmbed") {
            className = "container prismic-home__custom-embed";
          }

          return (
            <SmartStorefrontContent
              sliceID={slice.props?.sliceID}
              className={className}
            >
              {slice}
            </SmartStorefrontContent>
          );
        }}
      />
    </StorefrontContent>
  );
}
