import { defineExtension } from "@front-commerce/core";

const createPublicConfig = () => {
  return {
    name: "product-item-swatch-demo:public",
    values: {
      public: {
        theme: {
          productItem: {
            showSwatchGroup: true,
          },
        },
      },
    },
  };
};

export default function productItemSwatchDemo() {
  return defineExtension({
    name: "product-item-swatch-demo",
    meta: import.meta,
    configuration: {
      providers: [createPublicConfig()],
    },
  });
}
