import type { NextFunction, Request, Response } from "express";

const redirectionMap = [
  {
    incoming: "/redirection-to-home",
    outgoing: "/",
  },
  {
    incoming: "/redirection-keep-params",
    outgoing: "/",
    keepParams: true,
  },
  {
    incoming: "/go-to-fc-website",
    outgoing: "https://developers.front-commerce.com/",
  },
];

export default function exampleRedirections() {
  console.info("Custom Redirection module loaded!");

  return (req: Request, res: Response, next: NextFunction) => {
    const redirection = redirectionMap.find(
      (redirection) => redirection.incoming === req.path,
    );
    if (redirection) {
      const params = new URLSearchParams(req.query as Record<string, string>);
      res.redirect(
        `${redirection.outgoing}${
          redirection.keepParams ? `?${params.toString()}` : ""
        }`,
      );
    } else {
      next();
    }
  };
}
