# Tailwind example

This extension shows an example on how to use Tailwind with Front-Commerce

# Installation

These commands should be run at project level, not at extension level.

## Install Tailwind

```sh
pnpm add -D tailwindcss
```

## Generate Tailwind configuration

```sh
pnpm dlx tailwindcss init -p --ts
```

## Update your tailwind config

Update your `tailwind.config.ts` to include files from `app/theme`:

```diff
import type { Config } from 'tailwindcss'

export default {
- content: []
+ content: ["./app/**/*.{ts,tsx,js,jsx}"],
  theme: {
    extend: {},
  },
  plugins: [],
} satisfies Config
```

If you have components in some of your extensions, you need to add the related extensions' paths to the `content` directive.

## Setup PostCSS

Add the `tailwind` directive to the `postcss.config.js` file:

```diff
export default {
  plugins: {
    autoprefixer: {},
+    tailwindcss: {},
  },
};
```

## Inject Tailwind stylesheet

Copy the `tailwind.css` file in this directory to the `app` folder, then import this file in your `root.tsx` like so:

```diff
...
+ import "./tailwind.css";
...
```

You can now start your project and tailwind will be used for all your styles.

# Usage

You can test it by loading this module into your app by inject it in your `front-commerce.config.ts` file:

```diff
...
+import tailwind from "./example-extensions/tailwind";

export default defineConfig({
  extensions: [
    themeChocolatine(),
+    tailwind()
  ],
...
```

And update the `tailwind.config.js` with this:

```diff
/** @type {import('tailwindcss').Config} */
export default {
  content: [
    "./app/theme/**/*.{ts,tsx,js,jsx}",
+    "./example-extensions/tailwind/theme/**/*.{ts,tsx,js,jsx}",
  ],
  theme: {
    extend: {},
  },
  plugins: [],
}
```

Now you can head to [`http://localhost:4000/tailwind`](http://localhost:4000/tailwind) and check that Tailwind is working.

# More infos

If you want more infos about Tailwind setup with Remix, please check [this guide](https://tailwindcss.com/docs/guides/remix).
