import { defineConfig } from "@front-commerce/core/config";
import themeChocolatine from "@front-commerce/theme-chocolatine";
import magento2Demo from "./example-extensions/magento2-demo";
import magento2 from "@front-commerce/magento2";
import adobeB2B from "@front-commerce/adobe-b2b";
import contributionModeDemo from "./example-extensions/contribution-mode-demo";
import storesConfig from "./app/config/stores";
import cacheConfig from "./app/config/caching";
import rateLimiterConfig from "./app/config/rateLimiter";
import appCSPProvider from "./app/config/cspProvider";
import stripe from "@front-commerce/stripe";
import paypal from "@front-commerce/paypal";
import maintenanceModeDemo from "./example-extensions/maintenance-mode-demo";
import pwaConfig from "./app/config/pwa";
import payzen from "@front-commerce/payzen";
import adyen from "@front-commerce/adyen";
import errorBoundaryDemo from "./example-extensions/error-boundary-demo";
import analyticsConfigProvider from "./app/config/analyticsConfigProvider";
import hipay from "@front-commerce/hipay";
export default defineConfig({
  extensions: [
    themeChocolatine(),
    magento2({
      storesConfig,
      schema:
        "./node_modules/@front-commerce/adobe-b2b/generated/adobe-b2b-schema.gql",
    }),
    adobeB2B(),
    magento2Demo(),
    contributionModeDemo(),
    stripe("adobe-b2b"),
    hipay("magento2"),
    paypal("magento2"),
    payzen("front-commerce-magento2"),
    adyen("front-commerce-magento2"),
    maintenanceModeDemo(),
    errorBoundaryDemo(),
  ],
  stores: {
    default: {
      ...storesConfig.default,
      url: `${storesConfig.default.url}/shop`,
    },
  },
  cache: {
    ...cacheConfig,
    strategies: [
      ...cacheConfig.strategies,
      {
        implementation: "PerMagentoCustomerGroup",
        // Will scope all data from the CatalogPrice DataLoader with the customer group
        // (and other relevant price data loaders)
        // before they are transmitted to the previous strategy (Redis).
        // Other dataLoaders will use Redis storage in a standard fashion.
        supports: [
          "CatalogPrice",
          "CatalogProductChildrenPrice",
          "CatalogProductBundlePrice",
        ],
        config: {
          defaultGroupId: 0,
        },
      },
      {
        implementation: "PerMagentoCustomerTaxZone",
        supports: [
          "CatalogPrice",
          "CatalogProductChildrenPrice",
          "CatalogProductBundlePrice",
        ],
        config: {
          addressType: "shipping",
          defaultTaxZoneKey: "US",
        },
      },
    ],
  },
  rateLimiter: rateLimiterConfig,
  configuration: {
    providers: [appCSPProvider(), analyticsConfigProvider()],
  },
  v2_compat: {
    useApolloClientQueries: true,
    useFormsy: true,
  },
  pwa: pwaConfig,
});
