import { defineConfig } from "@front-commerce/core/config";
import themeChocolatine from "@front-commerce/theme-chocolatine";
import storesConfig from "./app/config/stores";
import cacheConfig from "./app/config/caching";
import rateLimiterConfig from "./app/config/rateLimiter";
import appCSPProvider from "./app/config/cspProvider";
import serverEventsConfig from "./app/config/serverEvents";
import pwaConfig from "./app/config/pwa";
import maintenanceConfig from "./app/config/maintenance";
import contributionMode from "./app/config/contributionMode";

export default defineConfig({
  extensions: [themeChocolatine()],
  stores: storesConfig,
  cache: cacheConfig,
  rateLimiter: rateLimiterConfig,
  serverEvents: serverEventsConfig,
  maintenance: maintenanceConfig,
  contributionMode: contributionMode,
  configuration: {
    providers: [appCSPProvider()],
  },
  v2_compat: {
    useApolloClientQueries: true,
    useFormsy: true,
  },
  pwa: pwaConfig,
});
