import { defineConfig } from "@front-commerce/core/config";
import themeChocolatine from "@front-commerce/theme-chocolatine";
import genericStoresConfig from "./app/config/stores";
import cacheConfig from "./app/config/caching";
import rateLimiterConfig from "./app/config/rateLimiter";
import appCSPProvider from "./app/config/cspProvider";
import pwaConfig from "./app/config/pwa";
import gezy from "@front-commerce/gezy";
import contentful from "@front-commerce/contentful";
import cms from "@front-commerce/cms";
import netup from "@front-commerce/netup";

import gezyDemo from "./example-extensions/gezy-demo";
import customCacheStrategy from "./example-extensions/custom-cache-strategy";
import contentfulDemo from "./example-extensions/contentful-demo";
import contributionModeDemo from "./example-extensions/contribution-mode-demo";
import priceVariantDemo from "./example-extensions/price-variant-demo";
import maintenanceModeDemo from "./example-extensions/maintenance-mode-demo";
import analyticsConfigProvider from "./app/config/analyticsConfigProvider";
import contributionMode from "./app/config/contributionMode";
import leaflet from "@front-commerce/leaflet";
import netupDemo from "./example-extensions/netup-demo";
import productItemSwatchDemo from "./example-extensions/product-item-swatch-demo";

const generateLangSubdomain = (lang: string, originalUrl: string) => {
  const url = new URL(originalUrl);
  url.hostname = `${lang}.${url.hostname}`;
  let result = url.toString();
  if (result.endsWith("/")) {
    result = result.slice(0, -1);
  }
  return result;
};

const storesConfig = {
  ...genericStoresConfig,
  default: {
    ...genericStoresConfig.default,
    gezyCatalogId: process.env.FRONT_COMMERCE_DEMO_GEZY_CATALOG_ID ?? "1",
  },
  en: {
    ...genericStoresConfig.default,
    gezyCatalogId: process.env.FRONT_COMMERCE_DEMO_GEZY_CATALOG_ID ?? "1",
    url: generateLangSubdomain("en", genericStoresConfig.default.url),
  },
  fr: {
    ...genericStoresConfig.default,
    locale: "fr-FR",
    default_country_id: "FR",
    gezyCatalogId: process.env.FRONT_COMMERCE_DEMO_GEZY_CATALOG_ID ?? "1",
    url: generateLangSubdomain("fr", genericStoresConfig.default.url),
  },
};

export default defineConfig({
  extensions: [
    themeChocolatine({
      themeOptions: {
        salesUnitDisplay: {
          pdp: true,
          addToCartPopin: true,
          cartPage: true,
          articleCard: true,
        },
      },
    }),
    gezy({ storesConfig }),
    gezyDemo(),
    customCacheStrategy(),
    contentful(),
    contentfulDemo(),
    contributionModeDemo(),
    maintenanceModeDemo(),
    priceVariantDemo(),
    leaflet(),
    cms("gezy"),
    netup("gezy"),
    netupDemo(),
    productItemSwatchDemo(),
  ],
  stores: storesConfig,
  contributionMode: contributionMode,
  cache: {
    ...cacheConfig,
    strategies: [
      ...cacheConfig.strategies,
      // This shows an example of a custom cache strategy, but isn't a real use case.
      {
        implementation: "PerGezyCustomer",
        supports: ["CatalogProductPrices", "CatalogProductPrices_*"],
        config: {
          defaultCustomerId: 0,
        },
      },
    ],
  },
  rateLimiter: rateLimiterConfig,
  configuration: {
    providers: [appCSPProvider(), analyticsConfigProvider()],
  },
  v2_compat: {
    useApolloClientQueries: true,
    useFormsy: true,
  },
  pwa: pwaConfig,
});
