import { defineConfig } from "@front-commerce/core/config";
import themeChocolatine from "@front-commerce/theme-chocolatine";
import magento1Demo from "./example-extensions/magento1-demo";
import magento1 from "@front-commerce/magento1";
import contributionModeDemo from "./example-extensions/contribution-mode-demo";
import storesConfig from "./app/config/stores";
import cacheConfig from "./app/config/caching";
import rateLimiterConfig from "./app/config/rateLimiter";
import appCSPProvider from "./app/config/cspProvider";
import payzen from "@front-commerce/payzen";
import stripe from "@front-commerce/stripe";
import paypal from "@front-commerce/paypal";
import maintenanceModeDemo from "./example-extensions/maintenance-mode-demo";
import pwaConfig from "./app/config/pwa";
import adyen from "@front-commerce/adyen";
import errorBoundaryDemo from "./example-extensions/error-boundary-demo";
import twicpics from "@front-commerce/twicpics";
import analyticsConfigProvider from "./app/config/analyticsConfigProvider";
import contributionMode from "./app/config/contributionMode";
import prismic from "@front-commerce/prismic";
import prismicDemo from "./example-extensions/prismic-demo";
import hipay from "@front-commerce/hipay";

export default defineConfig({
  extensions: [
    themeChocolatine(),
    magento1({ storesConfig }),
    magento1Demo(),
    contributionModeDemo(),
    payzen("front-commerce-magento1"),
    adyen("front-commerce-magento1"),
    stripe("magento1"),
    paypal("magento1"),
    hipay("magento1"),
    maintenanceModeDemo(),
    errorBoundaryDemo(),
    twicpics(),
    prismic(),
    prismicDemo(),
  ],
  stores: storesConfig,
  contributionMode: contributionMode,
  cache: {
    ...cacheConfig,
    strategies: [
      ...cacheConfig.strategies,
      {
        implementation: "PerMagentoCustomerGroup",
        // Will scope all data from the CatalogPrice DataLoader with the customer group
        // (and other relevant price data loaders)
        // before they are transmitted to the previous strategy (Redis).
        // Other dataLoaders will use Redis storage in a standard fashion.
        supports: [
          "CatalogPrice",
          "CatalogProductChildrenPrice",
          "CatalogProductBundlePrice",
        ],
        config: {
          defaultGroupId: 0,
        },
      },
      {
        implementation: "PerMagentoCustomerTaxZone",
        supports: [
          "CatalogPrice",
          "CatalogProductChildrenPrice",
          "CatalogProductBundlePrice",
        ],
        config: {
          addressType: "shipping",
          defaultTaxZoneKey: "US",
        },
      },
    ],
  },
  rateLimiter: rateLimiterConfig,
  configuration: {
    providers: [appCSPProvider(), analyticsConfigProvider()],
  },
  v2_compat: {
    useApolloClientQueries: true,
    useFormsy: true,
  },
  pwa: pwaConfig,
});
