import { defineConfig } from "@front-commerce/core/config";
import themeChocolatine from "@front-commerce/theme-chocolatine";
import magento2Demo from "./example-extensions/magento2-demo";
import magento2 from "@front-commerce/magento2";
import contributionModeDemo from "./example-extensions/contribution-mode-demo";
import deferExample from "./example-extensions/defer-example";
import storesConfig from "./app/config/stores";
import cacheConfig from "./app/config/caching";
import rateLimiterConfig from "./app/config/rateLimiter";
import contentful from "@front-commerce/contentful";
import contentfulDemo from "./example-extensions/contentful-demo";
import appCSPProvider from "./app/config/cspProvider";
import serverEventsConfig from "./app/config/serverEvents";
import stripe from "@front-commerce/stripe";
import paypal from "@front-commerce/paypal";
import payzen from "@front-commerce/payzen";
import maintenanceModeDemo from "./example-extensions/maintenance-mode-demo";
import externalLoginProvider from "@front-commerce/external-login-providers";
import pwaConfig from "./app/config/pwa";
import adyen from "@front-commerce/adyen";
import errorBoundaryDemo from "./example-extensions/error-boundary-demo";
import customFeatures from "./example-extensions/custom-features";
import analyticsConfigProvider from "./app/config/analyticsConfigProvider";
import contributionMode from "./app/config/contributionMode";
import hipay from "@front-commerce/hipay";

export default defineConfig({
  extensions: [
    themeChocolatine(),
    magento2({
      storesConfig,
      schema:
        "./node_modules/@front-commerce/magento2/generated/magento2-schema.gql",
    }),
    magento2Demo(),
    contentful(),
    contentfulDemo(),
    contributionModeDemo(),
    maintenanceModeDemo(),
    deferExample(),
    adyen("front-commerce-magento2"),
    stripe("magento2"),
    paypal("magento2"),
    payzen("front-commerce-magento2"),
    hipay("magento2"),
    maintenanceModeDemo(),
    externalLoginProvider(["facebook", "google"]),
    errorBoundaryDemo(),
    customFeatures(),
  ],
  stores: storesConfig,
  contributionMode: contributionMode,
  cache: {
    ...cacheConfig,
    strategies: [
      ...cacheConfig.strategies,
      {
        implementation: "PerMagentoCustomerGroup",
        // Will scope all data from the CatalogPrice DataLoader with the customer group
        // (and other relevant price data loaders)
        // before they are transmitted to the previous strategy (Redis).
        // Other dataLoaders will use Redis storage in a standard fashion.
        supports: [
          "CatalogPrice",
          "CatalogProductChildrenPrice",
          "CatalogProductBundlePrice",
        ],
        config: {
          defaultGroupId: 0,
        },
      },
      {
        implementation: "PerMagentoCustomerTaxZone",
        supports: [
          "CatalogPrice",
          "CatalogProductChildrenPrice",
          "CatalogProductBundlePrice",
        ],
        config: {
          addressType: "shipping",
          defaultTaxZoneKey: "FR",
        },
      },
    ],
  },
  rateLimiter: rateLimiterConfig,
  serverEvents: serverEventsConfig,
  configuration: {
    providers: [appCSPProvider(), analyticsConfigProvider()],
  },
  v2_compat: {
    useApolloClientQueries: true,
    useFormsy: true,
  },
  pwa: pwaConfig,
  server: {
    disableTrailingSlashRedirect: false,
    experimental_useInMemoryDynamicRouteCaching: true,
  },
});
