import { defineConfig } from "vitest/config";
import { vitestPlugin as frontCommerce } from "@front-commerce/remix/vite/testing";

export default defineConfig((env) => {
  return {
    test: {
      pool: "forks", // fixes an issue with vitest which causes the tests to hang see https://github.com/vitest-dev/vitest/issues/2008
      environment: "happy-dom",
      globals: true,
      setupFiles: ["./vitest.setup.ts"],
      coverage: {
        provider: "istanbul",
        reporter: ["text-summary"],
        exclude: ["public/**", "build/**", "./.front-commerce/**"],
      },
    },
    plugins: [
      frontCommerce({
        env,
      }),
    ],
  };
});
